#ifndef TYPES_H
#  define TYPES_H

#  include <cmath>

namespace Types
{
   struct Color
   {   
      Color(
         unsigned char red,
         unsigned char green,
         unsigned char blue
      ) :
         mRed(red), mGreen(green), mBlue(blue)
      {
      }

      Color() : mRed(255), mGreen(255), mBlue(255)
      {
      }

      static Color red()     { return(Color(255, 0,     0)); }
      static Color green()   { return(Color(0,   255,   0)); }
      static Color blue()    { return(Color(0,   0,   255)); }

      static Color cyan()    { return(Color(0,   255, 255)); }
      static Color magenta() { return(Color(255,   0, 255)); }
      static Color yellow()  { return(Color(255, 255,   0)); }
      static Color black()   { return(Color(0,   0,     0)); }

      static Color white() { return(Color()); }

      unsigned char mRed;
      unsigned char mGreen;
      unsigned char mBlue;
   };

   struct Point
   {
      int mX; int mY;

      Point(int x, int y) :
         mX(x), mY(y)
      {
      }

      Point(double x, double y) : mX(int(round(x))), mY(int(round(y)))
      {
      }

      Point() : mX(0), mY(0) {}
   };

   struct LineSegment
   {
      Point mStart;
      Point mEnd;
   };

   enum Font
   {
      NONE,
      COURIER,
      COURIER_BOLD,
      COURIER_OBLIQUE,
      COURIER_BOLD_OBLIQUE,
      HELVETICA,
      HELVETICA_BOLD,
      HELVETICA_OBLIQUE,
      HELVETICA_BOLD_OBLIQUE,
      SYMBOL,
      TIMES,
      TIMES_BOLD,
      TIMES_ITALIC,
      TIMES_BOLD_ITALIC,
      ZAPF_DINGBATS
   };
}

#endif
