// -------------------------------------------
// C++ Headers
// -------------------------------------------

#include <iostream>
#include <vector>

// -------------------------------------------
// Local Headers
// -------------------------------------------

#include "bmp.h"

// -------------------------------------------
// Using Declarations
// -------------------------------------------

using std::vector;

// -------------------------------------------
// d2r - convert degrees to radians
// -------------------------------------------

static double d2r(double degrees)
{
   // degrees * pi / 180

   return(degrees * 0.0174532925199);
}

// -------------------------------------------
// getPolygon - get points for nSided polygon
//              with the given radius at the
//              indicated point
// -------------------------------------------

static vector<Types::Point> getPolygon(
   int xCenter, int yCenter, int radius, int nSides
)
{
   vector<Types::Point> points;

   for(int i = 0, degrees = 0; i < nSides; i ++, degrees += 360 / nSides)
   {
      double radians = d2r(degrees);

      double x = xCenter + radius * cos(radians);
      double y = yCenter + radius * sin(radians);

      points.push_back(Types::Point(x, y));

      if(i + 1 == nSides)
      {
         // Close the polygon

         points.push_back(points[0]);
      }
   }

   return(points);
}

// -------------------------------------------
// main
// -------------------------------------------

int main()
{
   const int WIDTH  = 500;
   const int HEIGHT = 500;

   Bmp image(WIDTH, HEIGHT);

   Types::Color theColor = Types::Color::blue();
   Types::Color black    = Types::Color::black();

   image.drawRectangle(0, 0, WIDTH - 1, HEIGHT - 1, black);

   for(int nSides = 9, radius = 240; nSides >= 3; nSides --, radius -= 25)
   {
      vector<Types::Point> points =
         getPolygon(WIDTH / 2, HEIGHT / 2, radius, nSides);

      image.fillPolygon(points, theColor);
      image.drawPolyline(points, black);

      theColor.mRed   += 20;
      theColor.mGreen += 20;
   }

   string errMsg;
   string fileName = "test.bmp";

   if(!image.write(fileName, errMsg))
      std::cout << errMsg << "\n";

   else
      std::cout << "Wrote file: " << fileName << "\n";

   return(0);
}
