#ifndef BMP_H
#  define BMP_H

#  include <string>
#  include <vector>
#  include "types.h"

   using std::string;
   using std::vector;

   class Bmp
   {
      public:

         // -------------------------------------------
         // Bmp - Create bitmap, size: (width x height)
         // -------------------------------------------

         Bmp(int width, int height);

         // -------------------------------------------
         // Set pixel at (x, y) to the indicated color
         // -------------------------------------------

         void setPixel(
            int x, int y, unsigned char red, unsigned char green, unsigned char blue
         );

         // -------------------------------------------
         // Set pixel at (x, y) to the indicated color
         // -------------------------------------------
         
         void setPixel(
            int x, int y, const Types::Color &theColor
         );

         // -------------------------------------------
         // Draw rectangle at (x, y) with the indicated
         // width, height and color
         // -------------------------------------------

         void drawRectangle(
            int x,
            int y,
            int width,
            int height,
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Draw rectangle at (x, y) with the indicated
         // width, height and color
         // -------------------------------------------

         void drawRectangle(
            int x,
            int y,
            int width,
            int height,
            const Types::Color &theColor                       
         );

         // -------------------------------------------
         // Fill rectangle at (x, y) with the indicated
         // width, height and color
         // -------------------------------------------

         void fillRectangle(
            int x,
            int y,
            int width,
            int height,
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Fill rectangle at (x, y) with the indicated
         // width, height and color
         // -------------------------------------------

         void fillRectangle(
            int x,
            int y,
            int width,
            int height,
            const Types::Color &theColor                       
         );

         // -------------------------------------------
         // Fill polygon described by 'points' using
         // the indicated color
         // -------------------------------------------

         void fillPolygon(
            const vector<Types::Point> &points,
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Fill polygon described by 'points' using
         // the indicated color
         // -------------------------------------------

         void fillPolygon(
            const vector<Types::Point> &points,
            const Types::Color &theColor                       
         );

         // -------------------------------------------
         // Draw line from (x0, y0) to (x1, y1) using
         // the indicated color
         // -------------------------------------------

         void drawLine(
            int x0, int y0,
            int x1, int y1, 
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Draw line from (x0, y0) to (x1, y1) using
         // the indicated color
         // -------------------------------------------

         void drawLine(
            int x0, int y0,
            int x1, int y1, 
            const Types::Color &theColor                       
         );

         // -------------------------------------------
         // Draw polyline described by 'points' using
         // the indicated color
         // -------------------------------------------

         void drawPolyline(
            const vector<Types::Point> &points,
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Draw polyline described by 'points' using
         // the indicated color
         // -------------------------------------------

         void drawPolyline(
            const vector<Types::Point> &points,
            const Types::Color &theColor
         );

         // -------------------------------------------
         // Draw circle at (xCenter, yCenter) with the
         // indicated radius and color
         // -------------------------------------------

         void drawCircle(
            int xCenter,
            int yCenter,
            int radius,
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Draw circle at (xCenter, yCenter) with the
         // indicated radius and color
         // -------------------------------------------

         void drawCircle(
            int xCenter,
            int yCenter,
            int radius,
            const Types::Color &theColor
         );

         // -------------------------------------------
         // Fill circle at (xCenter, yCenter) with the
         // indicated radius and color
         // -------------------------------------------

         void fillCircle(
            int xCenter,
            int yCenter,
            int radius,
            unsigned char red,
            unsigned char green,
            unsigned char blue
         );

         // -------------------------------------------
         // Fill circle at (xCenter, yCenter) with the
         // indicated radius and color
         // -------------------------------------------

         void fillCircle(
            int xCenter,
            int yCenter,
            int radius,
            const Types::Color &theColor
         );

         // -------------------------------------------
         // write bmp to 'fileName', on error 'errMsg'
         // will be set and false returned, true is
         // returned on success
         // -------------------------------------------

         bool write(const string &fileName, string &errMsg);

         // -------------------------------------------
         // get bmp width and height
         // -------------------------------------------

         int getWidth()  const;
         int getHeight() const;

      private:

         vector<vector<Types::Color>> mImage;
         int mWidth;
         int mHeight;
   };

#endif
